<?php

/* ADD TYPO SECTION
***************************************************/
Goto_Kirki::add_section( 'typo', array(
 	'title'      => esc_attr__( 'Typography', 'goto' ),
    'priority'   => 1,
));


/*label*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'custom',
    'settings' => 'kirki_label_body_font',
    'section'  => 'typo',
    'default'  => goto_label(esc_attr__( 'Body font', 'goto' )),
));

/*body font*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'typography',
    'settings'  => 'typo_body',
    'section'   => 'typo',
    'transport' => 'auto',
    'default'   => array(
        'font-family'    => 'Open Sans',
        'variant'        => 'regular',        
        'color'          => '#666',
        'font-size'      => '14px',
        'line-height'    => '24px',
        'letter-spacing' => '0',
        'text-transform' => 'none',
    ),
    'output'      => array(
        array(
            'element' => 'body',
        ),
        array(
            'element'  => array(
                'a',
                '.wd-dest-layout-grid .wdd-item:hover .wddc-count',
                '.wd-dest-layout-carousel .wdd-item:hover .wddc-count',
                'input',
                'select',
                'textarea',
                'button'
            ),
            'property' => 'color',
            'choice'   => 'color'
        ),
        array(
            'element'  => array(
                'input',
                'select',
                'textarea',
                'button'
            ),
            'property' => 'font-size',
            'choice'   => 'font-size'
        ),
        array(
            'element'  => array(
                'input',
                'select',
                'textarea',
                'button'
            ),
            'property' => 'font-family',
            'choice'   => 'font-family'
        ),
        array(
            'element' => array(
                '.tl-radio-input input:checked + label >span:before'
            ),
            'property' => 'background-color',
            'choice'   => 'color'
        )
    )
));

/*label*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'custom',
    'settings' => 'kirki_label_heading_font',
    'default'  => goto_label(esc_attr__( 'Heading font', 'goto' )),
    'section'  => 'typo',
));

/*heading font*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'typography',
    'settings'  => 'typo_heading',
    'section'   => 'typo',
    'transport' => 'auto',
    'default'   => array(
        'font-family'    => 'Montserrat',
        'variant'        => '700',        
        'line-height'    => '1.2em',
        'color'          => '#333',
        'letter-spacing' => '0',
        'text-transform' => 'none',
    ),
    'output'      => array(
        array(
            'element' => 'h1, h2, h3, h4, h5, h6',
        ),
        array(
            'element'  => array(
                '.place-search-spn button',
                '.wd-tours-layout-carousel .wdt-price',
                '.tour-view-list .tlc-short-info strong',
                '.tl-sidebar-title',
                '#tl-results-count',
                '.tl-view-as span:first-child',
                '.tl-topbar-sortby',
                '.wpcf7-form input[type="submit"]',
                '.landing-btn'
            ),
            'property' => 'font-family',
            'choice'   => 'font-family'
        ),
        array(
            'element'  => array(
                '.tour-table-info td:first-of-type'
            ),
            'property' => 'color',
            'choice'   => 'color'
        )
    )
));

/*h1*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'text',
    'settings'    => 'typo_h1',
    'label'       => esc_attr__( 'H1', 'goto' ),
    'description' => esc_attr__( 'Font size', 'goto' ),
    'section'     => 'typo',
    'transport'   => 'auto',
    'default'     => '42px',
    'output'      => array(
        array(
            'element'  => 'h1',
            'property' => 'font-size'
        ),
    )
));

/*h2*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'text',
    'settings'    => 'typo_h2',
    'label'       => esc_attr__( 'H2', 'goto' ),
    'description' => esc_attr__( 'Font size', 'goto' ),
    'section'     => 'typo',
    'transport'   => 'auto',
    'default'     => '36px',
    'output'      => array(
        array(
            'element'  => 'h2',
            'property' => 'font-size'
        ),
    )
));

/*h3*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'text',
    'settings'    => 'typo_h3',
    'label'       => esc_attr__( 'H3', 'goto' ),
    'description' => esc_attr__( 'Font size', 'goto' ),
    'section'     => 'typo',
    'transport'   => 'auto',
    'default'     => '30px',
    'output'      => array(
        array(
            'element'  => 'h3',
            'property' => 'font-size'
        ),
    )
));

/*h4*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'text',
    'settings'    => 'typo_h4',
    'label'       => esc_attr__( 'H4', 'goto' ),
    'description' => esc_attr__( 'Font size', 'goto' ),
    'section'     => 'typo',
    'transport'   => 'auto',
    'default'     => '24px',
    'output'      => array(
        array(
            'element'  => 'h4',
            'property' => 'font-size'
        ),
    )
));

/*h5*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'text',
    'settings'    => 'typo_h5',
    'label'       => esc_attr__( 'H5', 'goto' ),
    'description' => esc_attr__( 'Font size', 'goto' ),
    'section'     => 'typo',
    'transport'   => 'auto',
    'default'     => '20px',
    'output'      => array(
        array(
            'element'  => 'h5',
            'property' => 'font-size'
        ),
    )
));

/*h6*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'text',
    'settings'    => 'typo_h6',
    'label'       => esc_attr__( 'H6', 'goto' ),
    'description' => esc_attr__( 'Font size', 'goto' ),
    'section'     => 'typo',
    'transport'   => 'auto',
    'default'     => '18px',
    'output'      => array(
        array(
            'element'  => 'h6',
            'property' => 'font-size'
        ),
    )
));